#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;

in vec3 POSITION;
in vec3 NORMAL;

out vec3 wpos;
out vec3 uv_alpha;

void main()
{
	gl_PointSize = 8.0 + smoothstep(0.75, 1.0, NORMAL.x)*8.f;
	uv_alpha.xy = NORMAL.yz;
	uv_alpha.z = smoothstep(0.0, 0.5, NORMAL.x);
	wpos = vec3(ModelViewMatrix * vec4(POSITION, 1.0));
	gl_Position = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
}
